/*
	Willam van Weelden RoboHelp ExtendScript library loader
	
	Include this file to load the Willam van Weelden ExtendScript library
	
*/

var libInit = false;//Set to true when the library is loaded.
var libVersion = 20120515;//Version of the library.

if(typeof(RoboHelp) != "undefined")
{
	
/* Global library variables */
	
	/* You may change the values of these variables */
	var v7Location = null;

	/* Do not change the value of the variables below this line. */
	var currentProject = null;
	var xpjextension = ".xpj";
	//Container files
	var FMContainer = "RHFrameDocs.apj";
	var WordContainer = "RHWordDocs.apj";
	var aliasfileextension = ".ali";
	var mapfileextension = new Array(".h", ".hh", ".hm");
	//Linked file information variables
	var LinkedFMDocs = false;
	var LinkedWordDocs = false;
	//CSH information variables
	var CSH = false;
	var MapNumbers = new Array();
	var TopicIds = new Array();
	var CSHTopicidKey = "topicid";
	var CSHMapnumberKey = "mapnumber";
	var CSHTopicKey = "topic";
	var CSHHighestNumberTaken = false;
	var CSHNoMoreMapNumbers = false;
	var CSHLastAssignedNumber = false;
	
	/* Include the library files */
Array.prototype.max = function() {
	var highest = false;
	for(var i = 0; i<this.length; i++) {
		if(!isNaN(parseFloat(this[i]))) {
			if(isNaN(highest))
				highest = parseFloat(this[i]);
			else if(parseFloat(this[i]) > highest)
				highest = parseFloat(this[i]);
	}
}
return highest;
}
Array.prototype.min = function() {
	var lowest = false;
	for(var i = 0; i<this.length; i++) {
		if(!isNaN(parseFloat(this[i]))) {
			if(isNaN(lowest))
				lowest = parseFloat(this[i]);
			else if(parseFloat(this[i]) < lowest)
				lowest = parseFloat(this[i]);
	}
}
return lowest;
}

Array.prototype.remove = function(from, to) {
	// Array Remove - By John Resig (MIT Licensed)
	//http://ejohn.org/blog/javascript-array-remove/
	var rest = this.slice((to || from) + 1 || this.length);
	this.length = from < 0 ? this.length + from : from;
	return this.push.apply(this, rest);
}

Array.prototype.toLowerCase = function() {
                var lowercasearray = new Array();
                for(var i = 0; i<this.length; i++)
                {
                               if(typeof(this[i]) == "string")
                                               lowercasearray.push(this[i].toLowerCase());
                               else
                                               lowercasearray.push(this[i]);
                }
                return lowercasearray;
}


function in_array (needle, haystack, strict) {
	
	if(is_array(needle))
	{
		alert("in_array expects first parameter to be a string. Array given.");
		return false;
	}
	else if(!is_array(haystack))
	{
		alert("in_array expects second parameter to be an array.")
		return false;
	}
	
	if(!strict)
		strict = false;
		
	var inarray = false;
	for(var i = 0; i<haystack.length; i++)
	{	
		if(strict)
		{
			if(needle === haystack[i])
			{
				inarray = true;
				break;
			}
		}
		else
		{
			if(needle == haystack[i])
			{
				inarray = true;
				break;
			}
		}
	}
	return inarray;
}
function is_array(object) {
	if(!isValidType(object))
		return false;
	else if(object.constructor.toString().indexOf("Array") == -1)
		return false;
	else
		return true;
}
function ExecuteBatchFile(command, waitforbatch) {
                
	if(command.isEmpty())
		return false;

	if(!waitforbatch)
		if(waitforbatch != false)
			waitforbatch = true;

	if(currentProject != null)
		var path = projectpath();
	else//No project. Save batfile to fallback directory
		var path = 'C:/';

	var batFileName = 'ExtendScriptBatchFile';
	var batFileExtension = '.bat';
	var batFile = new File(path+batFileName+batFileExtension);
	if(batFile.exists) {
		var i  = 0;
		while(batFile.exists) {
			i++;
			batFile = new File(path+batFileName+i+batFileExtension);
		}
	}

	command+= "\ndel /F /Q \"" + batFile.fsName + "\"";

	batFile.writeFile(command, false);
	if(!isFile(batFile, true))
		return false;

	batFile.execute();

	//Wait on batch file execution if needed
	if(waitforbatch) {
		while(batFile.exists) {
			msg(".");
			$.sleep(100);
		}
	}
	return true;
}

function openURL(url) {
	ExecuteBatchFile("start "+url+"  \n", false);
}
function getNextMapNumber() {
                
	//Assume that the mapnumbers are simple incremented numbers
	var lowestnumber = 1;
	var highestnumber = 4294967295;

	if(MapNumbers.length == 0)
		var nextnumber = lowestnumber;
	else if(!CSHHighestNumberTaken)//The hightest number has not yet been taken, or is not know to be taken yet.
		var nextnumber = MapNumbers.max() + 1;
	else
		var nextnumber = highestnumber+1;//Take the highest number so the search loop will start.

	if(nextnumber > highestnumber) {

		CSHHighestNumberTaken = true;//The highest number has been taken. No need to use the .max() method next time this function is called. Saves time.

		if(!CSHNoMoreMapNumbers) {//By default, there are mapnumbers.

			if(CSHLastAssignedNumber == false)//Check to see if the function already assigned a MapNumber before. No need to start counting at 1 when there is a higher number.
				nextnumber = lowestnumber;
			else
				nextnumber = CSHLastAssignedNumber+1;

			//The highest number has been taken. Determine if there is another number we can use.
			while(in_array(nextnumber, MapNumbers)) {
				nextnumber++;
			}

			if(nextnumber > highestnumber) {
				nextnumber = null;
				CSHNoMoreMapNumbers = true;//There are no more mapnumbers available. No need to loop the set numbers anymore when this function is called again. Saves time.
			}
		} else {
			nextnumber = null;
		}
	}
	if(nextnumber == null)
		alert("There are no more MapId's available in this project.");

	CSHLastAssignedNumber = nextnumber;

	return nextnumber;
}

function unloadCSH() {
	/*
		Reset CSH to false to allow the script to check if the CSH is already initialized.
		Called by unloadcurrentproject();
	*/
	CSH = false;
	MapNumbers = new Array();
	TopicIds = new Array();
}
function loadCSH() {
	/*
		This function loads all the CSH (MapId's, TopicId's and Topic references) into the array CSH.
		Done for easy searching so you don't have to parse all CSH file every time you need this info.
	*/
	
	msg("\nLoading all the project's Context Sensitivity\n");
	
	var aliasfile = "";
	var mapfiles = new Array();
	
	CSH = new Array();
	MapNumbers = new Array();
	TopicIds = new Array();
	
	var CSHtmpArray = new Array();
	
	for(var i = 1; i<=currentProject.FileManager.count; i++) {
		
		var file = currentProject.FileManager.item(i);
		if(file.extension == aliasfileextension)
			aliasfile = new File(file.path);
		else if(in_array(file.extension, mapfileextension))
			mapfiles.push(new File(file.path));
	}
	
	//Load all project topicid's and map#
	for(var i = 0; i<mapfiles.length; i++) {
		var mapfile = mapfiles[i];
		var mapfilecontent = mapfile.content().split("\n");
		
		for(var j = 0; j<mapfilecontent.length;j++) {
			var line = mapfilecontent[j];
			//Skip empty lines
			if(line.trim() != "") {
				
				//Both Map# and TopicId are mandatory. So no need to check that both exist
				line = line.replace("#define ", "");
				
				//Separator can be a tab or a space
				if(line.match("\t")) {
					line = line.split("\t");
				} else {
					line = line.split(" ");
				}
				
				var thislinearray = new Array();
				//Load topicid's
				thislinearray[CSHTopicidKey] = line[0];
				TopicIds.push(line[0]);
				//Load map#
				thislinearray[CSHMapnumberKey] = parseFloat(line[1]);
				MapNumbers.push(line[1]);
				CSHtmpArray.push(thislinearray);
			}
		}
	}
	
	//Now get all aliasses and combine the topicid's/Map# with the correct topics
	var AliasXML = new XML(aliasfile.content());
	var Aliasses = AliasXML.children();
	for(var i = 0; i<Aliasses.length(); i++) {
		var alias = Aliasses[i];
		
		//The alias file only contains links between topicid and topic. CSH without assigned topic are not in this file.
		var topicid = alias.attribute("name").toString();
		var topic = alias.attribute("link").toString().toLowerCase().replace(/\\/g,"/");
		for(var j = 0; j<CSHtmpArray.length; j++) {
			if(CSHtmpArray[j][CSHTopicidKey] == topicid) {
				CSHtmpArray[j][CSHTopicKey] = topic;
				CSH.push(CSHtmpArray[j]);
				CSHtmpArray.remove(j);
				break;
			}
			
		}
		
	}
	/*
		Elements still in the array are elements without a topic assigned. These elements need to be pushed to the CSH array too.
	*/
	for(var i = 0; i<CSHtmpArray.length; i++) {
		CSHtmpArray[i][CSHTopicKey] = false;//No topic available
		CSH.push(CSHtmpArray[i]);
	}
	msg("Finished loading Context Sensitivity\n");
}
/*
	For File.convertUTF8, see utf8.jsxinc
	For File.zip(), see zip.jsxinc
*/
File.prototype.content = function(content, encoding) {
	file = this;
	if(!content)
	   content = false;

	if(!encoding || encoding == true)
	   encoding = "UTF-8";
			   
	if(!content)
	   return file.readFile("UTF-8");
	else {
	   file.writeFile(content, encoding);
	   return true;
	}
}
File.prototype.extension = function() {
    return extension(this.fsName);
}
File.prototype.folder = function() {
    return folder(this.fsName);
}
File.prototype.readFile = function (encoding) {
	var thisfile = this;
	var szFilePath = thisfile.fsName;
	
	if(!isFile(thisfile))
	   return null;
	
	if(!encoding || encoding == true)
	   encoding == "UTF-8";
	
	//if it is RH9 then we will use the readWholeFile function
	if (IsRoboHelp9OrLater())
	   return RoboHelp.readWholeFile(szFilePath); //this takes care of BOM, encoding and all
    else {
	   var szRetVal = "";
	   var fileObj = new File(szFilePath);
	   fileObj.encoding = encoding;
	   fileObj.open("r");
	   while (!fileObj.eof) {
		   szRetVal += fileObj.readln()+"\n";
	   }
	   fileObj.close();
	   return szRetVal;
	}
}
File.prototype.writeFile = function (szOutput, encoding) {
	var thisfile = this;
	var szFilePath = thisfile.fsName;
	
	if(!encoding || encoding == true)
	   encoding = "UTF-8";
	
	var bSuccess = false;
	
	var fileObj = new File(szFilePath);
	fileObj.encoding = encoding;
	fileObj.open("w");
	fileObj.write(szOutput);
	fileObj.close();      
}

function extension(filename) {
	var ext = "";//If no extension, return an empty string.
	var index = filename.lastIndexOf(".");
	if(index != -1) {
		ext = filename.substr(index, filename.length - index).toLowerCase();
	}
	return ext;
}
function filename(absolutepath) {//Returns filename from absolute path.
	absolutepath = absolutepath.replace(/\\/g, "/");
	return absolutepath.substring(absolutepath.lastIndexOf("/")+1);
}
function FilePathExists(absolutepath) {
	var file = new File(absolutepath);
	return isFile(file, true);
}
function folder(absolutepath) {//Returns path from absolute path to file
	absolutepath = absolutepath.replace(/\\/g,"/");
	return absolutepath.substring(0,absolutepath.lastIndexOf("/"));
}
function isValidFilePath(path, filename) {
	if(!isValidType(path))
        return false;
	else if(is_array(path))
		return false;
    
    var bRetVal = !path.isEmpty() && FilePathExists(path);
    if (bRetVal) {
        bRetVal = false;
        path = path.toLowerCase();
        if (path.length > filename.length) {
            path = path.substr(path.length - filename.length);
            if (path == filename) {
                bRetVal = true;
            }
        }
    }
    return bRetVal;
}
function isFile(file, mustexist) {//Check whether an object is a file object and optionally whether the file exists on the file system.
	if(!mustexist)
		mustexist = false;
	
	var isfile = false;
	if(file instanceof File)
	{
		isfile = true;
		
		if(mustexist)
			if(!file.exists)
				isfile = false;
	}
	return isfile;
}
/*
	For Folder.zip(), see zip.jsxinc
*/
Folder.prototype.copy = function(tarFolder) {
    var srcFolder = this;
	var listOfFiles = new Array();
	
	if(!isFolder(tarFolder, true)) {
		tarFolder.create();
	}
	
    listOfFiles = srcFolder.getFiles("*.*");
    for (; listOfFiles.length > 0; ) {
        tFile = listOfFiles.pop();
        if (tFile instanceof Folder) {
            var tempFolder = Folder(tarFolder.fsName.concat("\\", tFile.displayName));
            
			if (!isFolder(tempFolder, true)) {
				tempFolder.create()
			}
            
			tFile.copy(tempFolder);
        }
        else {
            tFile.copy(tarFolder.fsName.concat("\\", tFile.displayName));
        }
    }
}
Folder.prototype.getFilesRecursive = function() {
	var folder = this;
	var editfiles = new Array();
	var files = folder.getFiles("*.*");
	for(var i = 0; i<files.length; i++)
	{
		var tempfile = files[i];
		 if (isFolder(tempfile)) {/* Load folder recursive */
			 var tmpfolder = new Folder(tempfile);
			 var temparray = tmpfolder.getFilesRecursive();
			 editfiles = editfiles.concat(temparray);
		 }
		else if(isFile(tempfile)) {
			 editfiles.push(tempfile);
		}
	}
	return editfiles;
}
function removeFolder(folder) {
	
	var string = 'rd "'+folder.fsName+'" /s /q';
	ExecuteBatchFile(string);
	
}
function isFolder(folder, mustexist) {//This is a function and not a prototype because this function must be available for all data types
	if(!mustexist)
		mustexist = false;
	
	var isfolder = false;
	if(folder instanceof Folder)
	{
		isfolder = true;
		
		if(mustexist)
			if(!folder.exists)
				isfolder = false;
	}
	return isfolder
}
Object.prototype.isLinked = function(type) {
	
	//This function works for the FileManager and the TopicManager.
	
    var file = this;
    var alltypes = "all";
     if(!type)
        type = alltypes;
 
	if(currentProject == null)
    {
        alert("Please load the project info using the function loadcurrentproject().");
        return null;
    }

	var allowedparents = new Array("[object TopicManager]", "[object FileManager]");
	if(!in_array(file.parent, allowedparents))
	{
		alert("The isLinked method can only be used on topics from the TopicManager and files from the FileManager.");
		return null;
	}
	
	if(!file.valid)//Check to see if topic/file exists
        return false;
	
	if(!is_array(LinkedFMDocs) || !is_array(LinkedWordDocs))
		loadLinkedFiles();
    
	var FileRelPath = file.path.substring(projectpath().length).replace(/\//g, "\\");
		
	var LinkedFiles = new Array();
    var linked = false;
 
    if(type.toLowerCase() == "framemaker" || type == alltypes)//Check FM
        LinkedFiles = LinkedFiles.concat(LinkedFMDocs);
    if(type.toLowerCase() == "word" || type == alltypes)//Check Word
        LinkedFiles = LinkedFiles.concat(LinkedWordDocs);
 
	if(in_array(FileRelPath.toLowerCase(), LinkedFiles.toLowerCase()))
		linked = true;
		
    return linked;
}
function unloadLinkedFiles() {
	LinkedFMDocs = false;
	LinkedWordDocs = false;
}
function loadLinkedFiles() {
	var Xpath = "//genfile/filename";
	var loadFilesThatAreLinked = function(filepath) {
		var LinkedFiles = new Array();
        var ContainerFile = new File(filepath);
        if(ContainerFile.exists)
        {
			var ContainerXML = new XML(ContainerFile.readFile());
			var LinkedFilesinContainer = ContainerXML.xpath(Xpath).children();
			for(var i = 0; i< LinkedFilesinContainer.length();i++)
			{
				LinkedFiles.push(LinkedFilesinContainer[i].toString());
			}
			return LinkedFiles;
        } else {
			return null;
		}
    }
	//Load FrameMaker
	LinkedFMDocs = loadFilesThatAreLinked(projectpath()+FMContainer);
	//Load Word
	LinkedWordDocs = loadFilesThatAreLinked(projectpath()+WordContainer);
}
function isValidType(value) {
    if (typeof (value) !== 'undefined' && value != null) {
        return true;
    }
    return false;
}

function confirm(message, noAsDflt, title) {
	/* Shorthand for Window.confirm because RoboHelp doesn't support the shorthand. */
	if(!message)
		return null;
	if(!noAsDflt)
		noAsDflt = false;
	if(!title)
		title = false;
	
	if(title == false)
		return Window.confirm(message, noAsDflt);
	else
		return Window.confirm(message, noAsDflt, title);
}

function prompt(message, preset, title) {
	/* Shorthand for Window.prompt because RoboHelp doesn't support the shorthand. */
	if(!message)
		return null;
	if(!preset)
		preset = "";
	if(!title)
		title = false;
	
	if(title == false)
		return Window.prompt(message, preset);
	else
		return Window.prompt(message, preset, title);
}
function clearmsg() {
	if(IsRoboHelp9OrLater() && currentProject != null)
		RoboHelp.project.clearOutputViewLog();
}
function closeproject() {
	if(currentProject == null)
	{
		loadcurrentproject(false);
		if(currentProject == null)
		{
			alert("Cannot close the current project as there is no project opened.");
			return null;
		}
	}
	
	var tmpproject = currentProject;
	unloadcurrentproject();
	RoboHelp.closeProject();
	return true;
}
function loadcurrentproject(showerror) {//If project is loaded after the library is initialized, this function must be run to initialize the variable currentProject
	if(!showerror)
		if(showerror != false)
			showerror = true;
	
	if(projectavailable())
		currentProject = RoboHelp.getCurrentProject();
	else if(showerror)
		alert("There is no RoboHelp project to load. Try loading the project and calling the function getcurrentproject() again.");
}
function msg(message) {
	if(currentProject != null)
		RoboHelp.project.outputMessage(message);
}
function openproject(xpjpath, updateifrequired) {
	if(!updateifrequired)
		updateifrequired = false;
	
	if(!isValidType(xpjpath) || !isValidFilePath(xpjpath, xpjextension))
		return false;
	
	var prj = new File(xpjpath);
	if(prj.folder()+"/" == projectpath())
	{
		alert("This project is already open.");
		return false;
	}
	else
	{
		unloadcurrentproject();//Unload current project from variable currentProject.
		RoboHelp.openProject(prj.fsName, updateifrequired);//Open project
		loadcurrentproject(false);//Load opened project into variable currentProject.
		return true;
	}
	
}
function openprojectdialog(updateifrequired) {
	if(!updateifrequired)
		updateifrequired = false;
	
	var prj = new File();
	prj = prj.openDlg("Choose project to open", "Project file:*.xpj", false);
	if(!isValidType(prj) || !isValidFilePath(prj.fsName, xpjextension))
		return false;
	
	return openproject(prj.fsName, updateifrequired);

}
function unloadcurrentproject() {
	unloadCSH();
	unloadLinkedFiles();
	currentProject = null;
}
function projectavailable() {
	if(isValidType(RoboHelp.getCurrentProject()))
		return true;
	else
		return false;
}

function projectpath() {
	if(currentProject != null)
		return currentProject.path.replace(/\\/g, "/")+"/";
	else
		return null;
}
function projecttitle() {
	if(currentProject != null)
		return currentProject.title;
	else
		return null;
}
function projectlanguage() {
	if(currentProject == null)
		return null
	else
	{
		var projectlang = "en";
		if (IsRoboHelp9OrLater()) {
			try {
				projectlang = RoboHelp.Language.getNameFromID(currentProject.language);
			} catch (e) {
				//Silently swallow exceptions
			}
		}
		return projectlang;
	}
}
function IsRoboHelp9OrLater() {
    var versionString = RoboHelp.version;
    var iVersion = parseInt(versionString);
    return (iVersion >= 9);
}
function saveSetting(setting, value, scope) {
    
    if(!scope) {
        scope = "project";
    }
	
    if(currentProject == null && scope != "global") {
		return false;
	}

	var settings = allSettings(scope);
	if(settings == false || settings.toString().isEmpty())//No file yet or empty
		settings = new XML("<scriptsettings/>");
	
	//Is this setting already availble?
	if(!settings.child(setting).toString().trim().isEmpty()) {
		settings.replace(setting, new XML("<"+setting+"><![CDATA["+htmlspecialchars(value)+"]]></"+setting+">"));//Replace existing value
	} else {
		settings.appendChild(new XML("<"+setting+"><![CDATA["+htmlspecialchars(value)+"]]></"+setting+">"));//Add new value
	}

	
	var settingsFileResource = getSettingsFile(scope);
    settingsFileResource.content("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+settings.toXMLString());
	return true;
}
function loadSetting(setting, scope) {
	if(!scope) { scope = "project"; }
    
    if(currentProject == null && scope != "global") {
		return null;
	}
	var settings = allSettings(scope);
	if(settings == false || settings.toString().isEmpty()) {
		return null;
	} else {
		return settings.child(setting).toString();
	}
}
function allSettings(scope) {
     var settingsFileResource = getSettingsFile(scope);
	if(isFile(settingsFileResource), true)//Does the settings file already exist?
		return new XML(settingsFileResource.content());
	else
		return false;
}
function getSettingsFile(scope) {
    //Settings file name
    var settingsFile = "scriptSettingFile.xml";
    
    if(scope == "global") {
        var settingsFile = new File(Folder.appData.fsName + '/'+ settingsFile);
    } else if (currentProject != null){
        var settingsFile = new File (projectpath()+settingsFile);
    } else {
        var settingsFile = null;
    }
    return settingsFile;
}
Object.prototype.outputDir = function() {
	
	if(this.parent != "[object SSLManager]") {
	   alert("You can only use the method .outputDir() on SSL objects");
	   return null;
	}
	
	return folder(this.outputFileName)+"/";
}
String.prototype.count = function (s1) {   
        return (this.length - this.replace(new RegExp(s1,"g"), '').length) / s1.length;  
}
String.prototype.isEmpty = function () {
	var isempty = true;
	if(isValidType(this))
	{
		if(this.trim().length > 0)
			isempty = false;
	}
	return isempty;
}
String.prototype.toBoolean = function() {
	var truearray = new Array("true", "1");
	var falsearray = new Array("false", "0", "-1");
	if(in_array(this, truearray))
		return true;
	else if(in_array(this, falsearray))
		return false;
	else
		return null;
}
String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/g, "");
}
Object.prototype.balancedDelete = function (contentdelete) {
    var Token = this;
 
    if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the balancedDelete function on tokens from the TokenManager.");
        return null;
    }
 
    var SingleDelete = function(token) {
        var Single = false;
 
        if(token.tokenType == RoboHelp.TokenType.TOKENTEXT)
        {
            Single = true;
        }
        else if(token.tokenType == RoboHelp.TokenType.TOKENTAG)
        {
            if(token.name.match(/(<\/)/g) || token.name.match(/(\/>)/g))//End tags or shorthand tags
                Single = true;
            else
            {   
				//If no match of yet, make sure that the tag is not a known html shorthand tag. HTML 4.01 allows shorthand tags like <br>
				var ShortTags = new Array("area","base","basefont","br","col","frame","img","input","link","meta","param");
				if(token.isTag(ShortTags))
					Single = true;
			}
        }
        return Single;
    }
 
    if(SingleDelete(Token))
        Token.delete();
    else
    {
            var TokenDelete = new Array(Token);
            var tag = cleantag(Token.name);
            var endTag = "/"+tag;
            var i = 0;
            var RetreivedAll = false;
            var sToken = Token.next;
            while(RetreivedAll == false)
            {
                if(sToken.isTag(tag))
                {
                    i++;
                    if(contentdelete)
                        TokenDelete.push(sToken);
                }
                else if(sToken.isTag(endTag) && i != 0)
                {
                    i--;
                    if(contentdelete)
                        TokenDelete.push(sToken);
                }
                else if(sToken.isTag(endTag) && i == 0)
                {
                    TokenDelete.push(sToken);
                    RetreivedAll = true;
                 }
                else if(contentdelete)
                    TokenDelete.push(sToken);
 
                sToken = sToken.next;
            }
 
            for(var j = 0;j<TokenDelete.length;j++)
            {
                TokenDelete[j].delete();
            }
     }
    return true;
}
Object.prototype.hasAttribute = function(attribute, empty) {
	var Token = this;
 
     if(!empty)
        empty = false;
	
	if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the hasAttribute functions on tokens from the TokenManager.");
        return null;
    }
    else if(!attribute)
    {
        alert("No attribute specified");
        return null;
    }
 
    if(Token.tokenType != RoboHelp.TokenType.TOKENTAG)//It's not a tag at all
        return false;
 
    var hasAttribute = false;
 
    if(Token.getAttribute(attribute) != "")
        hasAttribute = true;
    else if(empty)//Search for empty attribute
    {
        var attrstring = attribute+'=("|\')';//Append =" or =' to attribute name.
        var attr = new RegExp(attrstring);
        if(Token.name.match(attr))
            hasAttribute=true;
    }
 
    return hasAttribute;
}
Object.prototype.isTag = function(Tag, casesensitive) {
    var Token = this;
	
	if(!casesensitive)
		casesensitive = false;
 
    if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the isTag functions on tokens from the TokenManager.");
        return null;
    }
 
    if(Token.tokenType != RoboHelp.TokenType.TOKENTAG)//It's not a tag at all
        return false;
 
    if(!Tag)//No tag specified and this is a tag so return true
        return true;
 
    var isTag = false;
    var fullTag = Token.name;
    var TagName = cleantag(fullTag);//Get the tag name without brackets
 
    if(!is_array(Tag))
    {
        var TagArray = new Array;
        TagArray[0] = Tag;
    } else {
        var TagArray = Tag;
    }
	
	if(!casesensitive)
	{
		//Matching is not case sensitive. Put everything in lower case
		TagName = TagName.toLowerCase();
		TagArray = TagArray.toLowerCase();
	}
 
	if(in_array(TagName, TagArray))
		isTag = true;

    return isTag;
}
function  cleantag (tag) {
	if(tag.match(" ")) {
		tag = tag.split(" ")[0];//Remove attributes the lazy way. All attributes are separated by spaces from the tag name.
	}
	
	tag = tag.replace(/[<>]/g, "");
	
    if(tag.substr(-1) == "/")
		tag = tag.substr(0,tag.length-1);
	
	return tag;
}
Object.prototype.CSH = function(topicid, mapnumber) {
	//Object to get the CSH of a topic.
	if(this.parent != "[object TopicManager]") {
		alert("The CSH method can only be used on topics from the TopicManager");
		return null;
	}
	
	//Project CSH settings are not initialized yet.
	if(CSH == false)
		loadCSH();
	
	var topicrelpath = this.path.toLowerCase().replace(/\\/g, "/").replace(projectpath().toLowerCase(), "");
	
	if(!topicid) {
		topicid = false;
		mapnumber = false;
	}
	
	//Get the CSH for the topic and return that.
	if(topicid === false) {
		var topicCSH = new Array();
		
		for(var i = 0; i<CSH.length; i++) {
			if(CSH[i][CSHTopicKey] != false) {
				if(CSH[i][CSHTopicKey].toLowerCase() == topicrelpath) {
					var tmpArray = [];
					tmpArray[CSHTopicidKey] = CSH[i][CSHTopicidKey];
					tmpArray[CSHMapnumberKey] = CSH[i][CSHMapnumberKey];
					
					topicCSH.push(tmpArray);
				}
			}
		}
		
		if(topicCSH.length >= 1)
			return topicCSH;
		else
			return false;
			
	} else {//Set CSH for the topic.
		
		msg("\nSetting CSH for topic \""+topicrelpath+"\"\n");
		
		var returnvalue = true;
		
		if(!in_array(topicid, TopicIds) && !in_array(mapnumber, MapNumbers)) {
			
			currentProject.MapIdManager.newMapId(topicid, mapnumber);
			currentProject.MapIdManager.assign(topicid, topicrelpath);
			
			//Add new mapnumbers to the correct arrays
			var tmpArray = new Array();
			tmpArray[CSHTopicidKey] = topicid;
			tmpArray[CSHMapnumberKey] = mapnumber;
			tmpArray[CSHTopicKey] = topicrelpath;
			CSH.push(tmpArray);
			
			MapNumbers.push(mapnumber);
			TopicIds.push(topicid);
		} else if (in_array(topicid, TopicIds) && in_array(mapnumber, MapNumbers)) {
			//Assume that given id's are assigned correctly.
			currentProject.MapIdManager.assign(topicid, topicrelpath);
			//Assign the topic to the id's in the CSH array.
			for(var i = 0; i<CSH.length; i++) {
				if(CSH[CSHTopicidKey] == topicid) {
					CSH[CSHTopicKey] = topicrelpath;
					break;
				}
			}
		} else {
			//There is something wrong
			returnvalue = false;
			alert("Error while assigning CSH. Map# and TopicId must both exists or must both be absent from project.");
		}
		
		return returnvalue;
		
	}
}
/* Support functions for File.convertUTF8()*/
File.prototype.convertUTF8 = function (fileencoding) {
	
	if(!fileencoding)//Default file encodings
		fileencoding = 'iso-8859-1';

	var file = this;    

	content = file.readFile(fileencoding);

	file.writeFile(content);
	
	return true;
	
}
function htmlspecialchars(string) {
	if(!string.isEmpty()) {
	   string = string.replace(/&/g,"&amp;");
	   string = string.replace(/</g,"&lt;");
	   string = string.replace(/>/g,"&gt;");
	   string = string.replace(/"/g,"&#039;");
	   string = string.replace(/'/,"&apos;");
	}
	return string;
}
File.prototype.zip = function (zipname, method, compression, archivecommand) {//Zip a single file
	var file = this;
	
	if(!isFile(file, true))
	{
		alert("File "+file.fsName+" does not exist. Cannot zip file.");
		return false;
	}
	else if(!ZipLocation())//No location. Cannot zip file
		return false;
	else if(zipname.isEmpty())
	{
		alert("No name for archive specified. Cannot zip file "+file.fsName);
		return false;
	}

	if(!method)
		method = "tzip";
	if(!compression)
		compression = false;
	if(!archivecommand)
		archivecommand = "a";
		
	var batchtxt = "";
		
	if(validZipMethod(method) && validZipCompression(compression) && validArchiveCommand(archivecommand))
	{
		batchtxt+='"'+v7Location+'" '+archivecommand+' -'+method+' "'+zipname+'" '+'"'+file.fsName+'"';
		if(compression != false)
			batchtxt+=' -mx'+compression;
			
		return ExecuteBatchFile(batchtxt);
	}
	else
	{
		alert("Invalid options for archive specified. Cannot zip file "+file.fsName);
		return false;
	}
	
}
Folder.prototype.zip = function (zipname, method, compression, archivecommand) {//zip a folder. This is always recursive
	var folder = this;
	
	if(!isFolder(folder, true))
	{
		alert("Folder "+folder.fsName+" does not exist. Cannot zip folder.");
		return false;
	}
	else if(!ZipLocation())//No location. Cannot zip file
		return false;
	else if(zipname.isEmpty())
	{
		alert("No name for archive specified. Cannot zip file "+file.fsName);
		return false;
	}

	if(!method)
		method = "tzip";
	if(!compression)
		compression = false;
	if(!archivecommand)
		archivecommand = "a";
	
	var batchtxt = "";
	
	if(validZipMethod(method) && validZipCompression(compression) && validArchiveCommand(archivecommand))
	{
		batchtxt+='"'+v7Location+'" '+archivecommand+' -'+method+' "'+zipname+'" '+'"'+folder.fsName+"\\*"+'"';
		if(compression != false)
			batchtxt+=' -mx'+compression;
			
		return ExecuteBatchFile(batchtxt);
	}
	else
	{
		alert("Invalid options for archive specified. Cannot zip folder "+folder.fsName);
		return false;
	}
	
}
/* Support functions for File.zip() and Folder.zip() */
function isValid7ZipPath () {
	if(!isValidFilePath(v7Location, "7z.exe")  && !isValidFilePath(v7Location, "7za.exe"))
		return false;
	else
		return true;
}
function validArchiveCommand(archivecommand) {
	var v7commands = new Array("a", "u");//Add to archive (or create new) / update file in archive, 
	if(in_array(archivecommand, v7commands))
		return true;
	else
		return false;
}
function validZipCompression(compression) {
	var v7compression = new Array("0", "1", "3", "5", "7", "9", false);//Compression goes: none, very low, fast, normal, high, ultra, use 7zip default.
	if(in_array(compression, v7compression))
		return true;
	else
		return false;
}
function validZipMethod(method) {
	var v7methods = new Array("t7z", "tgzip", "tzip", "tbzip2", "tiso", "tudf");//Supported archive types.
	if(in_array(method, v7methods))
		return true;
	else
		return false;
}
function ZipLocation() {//Add location of 7-Zip executable to v7Location. Return true on succes, false on fail.
	if(!isValid7ZipPath())
	{
		var ziploc = new File();
		ziploc = ziploc.openDlg("Please choose 7-Zip executable to zip the file","7-Zip executable: 7z.exe;7za.exe");
		if(isFile(ziploc, false))
			v7Location = ziploc.fsName;
			
		if(!isValid7ZipPath())
		{
			alert("The path to 7-Zip is not valid.");
			return false;
		}
	}
	return true;
}

	/* Run initial functions */
	loadcurrentproject(false);//Load the current project into the variable currentProject.
	
	libInit = true;//Set lib to loaded
}

var rootimages = new Array();
var matched = new Array();

if(!libInit)
	alert("Please start RoboHelp and open a project.");
else
{
	if(currentProject == null)
	{
		if(openprojectdialog())
			run();
		else
			alert("You must open a project to create eBook output.");
	}
	else
		run();
}
function run() {
	
	alert('When the script starts, the RoboHelp window may go white and show "Not Responding". Do not close RoboHelp. You can check whether the script is running with Task Manager.');
	
	/* Get images from project root */
	getRootImages();
	
	/* Find image references in topics */
	matchImages();
	
	/* Move the images and update the topics. */
	moveImages();	
	
	/* Close project */
	var path = new Folder(currentProject.path.replace(/\\/g, "/"));
	closeproject();
	
	/* Remove the CPD */
	var cpd = new File(path.getFiles("*.cpd")[0]);
	cpd.remove();
	
	/* Reopen project */
    var prj = new File(path.getFiles("*.xpj")[0]);
    openproject(prj.fsName);
	
	alert('Script finished. Check output view for moved images.');
}
function moveImages() {
	
	for(var i=0; i<rootimages.length; i++) {
		
		var temp = getMatch(rootimages[i]);		
		
		if(temp !== false) {//Only one topic
			
			var folderToMove = folder(temp);
			
			if(folderToMove+"/" != projectpath()) {
			
				msg("Moving the image \""+rootimages[i]+"\" to the folder "+folderToMove+"\n\n");
				
				var image = new File(projectpath()+rootimages[i]);
				var imagename = rootimages[i];
				var targimage = folderToMove+'/'+imagename;
				
				var testfile = new File(targimage);
				if(isFile(testfile, true)) {/* Image already exits */
					imagename = generateUniqueImageName(folderToMove, imagename);
					targimage = folderToMove+'/'+imagename;
				}
				
				image.copy(targimage);
				image.remove();
				
				updateTopic(temp, rootimages[i], imagename);
			
			}
		}
		
	}
	
}
function generateUniqueImageName(folder, imagename) {
	var id = uniqid();
	var file = new File(folder+'/'+id+imagename);
	if(isFile(file, true)) {/* Image exists: rerun for new name */
		newname = generateUniqueImageName(folder, '1_'+imagename);
	} else {
		newname = id+imagename;
	}
	return newname;
}
function uniqid (prefix, more_entropy) {
  // +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // +    revised by: Kankrelune (http://www.webfaktory.info/)
  // %        note 1: Uses an internal counter (in php_js global) to avoid collision
  // *     example 1: uniqid();
  // *     returns 1: 'a30285b160c14'
  // *     example 2: uniqid('foo');
  // *     returns 2: 'fooa30285b1cd361'
  // *     example 3: uniqid('bar', true);
  // *     returns 3: 'bara20285b23dfd1.31879087'
  if (typeof prefix == 'undefined') {
    prefix = "";
  }

  var retId;
  var formatSeed = function (seed, reqWidth) {
    seed = parseInt(seed, 10).toString(16); // to hex str
    if (reqWidth < seed.length) { // so long we split
      return seed.slice(seed.length - reqWidth);
    }
    if (reqWidth > seed.length) { // so short we pad
      return Array(1 + (reqWidth - seed.length)).join('0') + seed;
    }
    return seed;
  };

  // BEGIN REDUNDANT
  if (!this.php_js) {
    this.php_js = {};
  }
  // END REDUNDANT
  if (!this.php_js.uniqidSeed) { // init seed with big random int
    this.php_js.uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
  }
  this.php_js.uniqidSeed++;

  retId = prefix; // start with prefix, add current milliseconds hex string
  retId += formatSeed(parseInt(new Date().getTime() / 1000, 10), 8);
  retId += formatSeed(this.php_js.uniqidSeed, 5); // add seed hex string
  if (more_entropy) {
    // for more entropy we add a float lower to 10
    retId += (Math.random() * 10).toFixed(8).toString();
  }

  return retId;
}
function topicDepth(topic) {
	var ppath = currentProject.path.replace(/\\/g, "/");
	var tpath = topic.replace(/\\/g, "/");
	var remains = tpath.substr(ppath.length+1);
	return remains.count("/");
}
function updateTopic(topic, oldimagename, newimagename) {
	var numberofdirs = topicDepth(topic);
	
	var tokens = RoboHelp.getTokenManager(topic);
	if(typeof(tokens) != "undefined") {
		if(tokens.count > 0) {
			var token = tokens.item(1);
			while(typeof(token) != "undefined") {
				
				if(token.isTag("img")) {
					
					var src = token.getAttribute("src").replace(/\\/g, "/");
					var srcclean = src.replace(/(\.\.\/)/g, "");
					
					if(srcclean == oldimagename && src.count("/") == numberofdirs) {
						
						token.setAttribute("src", newimagename);
						
					}
					
				}
				
				token = token.next;
			}
		}
	}
	tokens.save();
	tokens.close();
}
function getMatch(imagename) {
	var found = 0;
	var topic;
	
	for(var i = 0; i<matched.length; i++) {
		var img = matched[i]['images'];
		
		for(var j = 0; j<img.length; j++) {
			if(img[j] == imagename) {
				found++;
				topic = matched[i]['topic'];
			}
		}
	}
	
	if(found == 1) {
		return topic;
	} else {
		return false;
	}
	
}
function getRootImages() {
	var folder = new Folder(currentProject.path);
	var listOfFiles = folder.getFiles("*.*");
	
	for (; listOfFiles.length > 0; ) {
        tFile = listOfFiles.pop();
        if (tFile instanceof File) {
            var images = new Array(".jpg", ".gif", ".bmp", ".png");
			
			if(in_array(tFile.extension(), images)) {
				rootimages.push(filename(tFile.fsName));
			}
        }
    }
}
function matchImages() {

	var topics = currentProject.TopicManager;
	for(var i = 1; i<=topics.count; i++) {
		var topic = topics.item(i);
		var imageimg = getTopicImages(topic);
		
		if(imageimg !== false) {
			var temp = new Array();
			temp['topic'] = topic.path;
			temp['images'] = imageimg;
			matched.push(temp);
		}
		
	}

}
function getTopicImages(topic) {
	
	var numberofdirs = topicDepth(topic.location);
	
	var images = new Array();
	
	var tokens = RoboHelp.getTokenManager(topic.path);
	if(typeof(tokens) != "undefined") {
		if(tokens.count > 0) {
			var token = tokens.item(1);
			while(typeof(token) != "undefined") {
				
				if(token.isTag("img")) {
					
					var src = token.getAttribute("src").replace(/\\/g, "/");
					
					if(src.count("/") == numberofdirs) {
						images.push(src.replace(/(\.\.\/)/g, ""));
					}
				}
				token = token.next;
			}
		}
	}
	
	if(images.length > 0) {
		return images;
	} else {
		return false;
	}
}
